/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.dsl;

import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.impl.dsl.CategoryBuilderImpl;
import io.gitlab.jfronny.libjf.config.impl.dsl.DslConfigInstance;
import io.gitlab.jfronny.libjf.config.impl.io.DefaultConfigIO;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigBuilderImpl
extends CategoryBuilderImpl<ConfigBuilderImpl>
implements ConfigBuilder<ConfigBuilderImpl> {
    public DslConfigInstance built;
    public Consumer<ConfigInstance> load;
    public Consumer<ConfigInstance> write;
    public Path path;

    public ConfigBuilderImpl(String id) {
        super(id, "");
        this.load = DefaultConfigIO.loader(id);
        this.write = DefaultConfigIO.writer(id);
        this.path = FabricLoader.getInstance().getConfigDir().resolve(id + ".json5");
    }

    @Override
    public ConfigBuilderImpl setLoadMethod(Consumer<ConfigInstance> load) {
        this.checkBuilt();
        this.load = load;
        return this;
    }

    @Override
    public ConfigBuilderImpl setWriteMethod(Consumer<ConfigInstance> write) {
        this.checkBuilt();
        this.write = write;
        return this;
    }

    @Override
    public ConfigBuilderImpl executeAfterWrite(Consumer<ConfigInstance> method) {
        this.checkBuilt();
        this.write = this.write.andThen(method);
        return null;
    }

    @Override
    public ConfigBuilderImpl setPath(Path path) {
        this.checkBuilt();
        this.path = path;
        return this;
    }

    @Override
    public DslConfigInstance build() {
        this.markBuilt();
        this.built = new DslConfigInstance(this.id, this.entries, this.presets, this.referencedConfigs, this.categories, () -> this.built, this.verifiers, this.migrations, this.load, this.write, this.path);
        this.built.load();
        return this.built;
    }
}

